<?php
	Class LangEN {
		public $langs = array(
			'under_maintenance'					=>	'The site is under maintenance process. Please come back later!',
			'connection_timeout_err'			=>  'Connection timeout, please try again later!',
			'invalid_input_err'					=>  'Invalid input!',
			'username_min_length_err'			=>	'Username must be at least 6 characters!',
			'username_max_length_err'			=>	'Username must be at most 16 characters!',
			'username_invalid_chars_err'		=>	'Alphanumeric input only!',
			'email_invalid_err'					=>	'Email must be a valid email!',
			'email_invalid_suppliers_err'		=>	'You must not use this email to register. Please choose the email of other suppliers!',
			'password_min_length_err'			=>	'Password must be at least 6 characters!',
			'password_max_length_err'			=>	'Password must be at most 32 characters!',
			'passwords_not_match_err'			=>	'Passwords do not match!',
			'captcha_incorrect_err'				=>	'Invalid captcha code. Please try again!',
			'signup_too_often_err'				=>	'Too many accesses from this IP address. Please try again later!',
			'username_exists_err'				=>	'User name already exists!',
			'email_exists_err'					=>	'Email already exists!',
			'country_not_allowed_err'			=>	'Country not allowed!',
			'undefined_err'						=>	'Something went wrong!',
			'register_success'					=>	'Your account has been successfully registered!',
			'empty_fields_err'					=>	'All fields cannot be empty!',
			'incorrect_username_or_password_err'	=>	'Please enter correct username or password!',
			'account_banned_err'				=>	'Your account has been permanently banned. Reason: policy violation!',
			'incorrect_2FA_err'					=>	'Please enter correct 2FA code to continue!',
			'login_success'						=>	'Login successfully!',
			'send_mail_too_often_err'			=>	'Please wait for 5 minutes before requesting another email!',
			'email_not_exists_err'				=>	'Your email address is not registered!',
			'send_verify_email_success'			=>	'We have sent an email with a confirmation link to %s. You need to click this link to continue. This link will expire in 2 hours.', //$email
			'unavailable_feature_err'			=>	'This feature is currently unavailable',
			'verified_email_err'				=>	'Your email has been verified!',
			'login_required_err'				=>	'You have to login to continue!',
			'logout_success'					=>	'Logging out!',
			'captcha_incorrect_many_times_err'	=>	'Failed captcha too many times. Please try again in 10 minutes!',
			'wait_hourly_faucet'				=>	'Please wait for %d minutes, %d seconds to the next faucet claim!', //$email, $seconds
			'claim_success'						=>	'You got %.8f BNB!', //(reward / 100000000)
			'out_of_spins_err'					=>	'Out of spins. To get more bonus spins, please play more our games!',
			'dismiss_noti_success'				=>	'Dismiss notification successfully!',
			'empty_commission_balance_err'		=>	'Your avaiable commissions balance is empty!',
			'invalid_gift_code_err'				=>	'Please enter valid gift code!',
			'incorrect_gift_code_err'			=>	'This gift code is invalid or deleted!',
			'used_gift_code_err'				=>	'This gift code has been used!',
			'apply_gift_success'				=>	'Gift code is successfully applied!',
			'password_changed_success'			=>	'Password has been successfully changed!',
			'incorrect_ver_code_err'			=>	'The verification code does not exist or has expired!',
			'incorrect_2FA_err2'				=>	'You need to provide a valid token to enable 2FA for your account!',
			'2FA_enabled_success'				=>	'2FA Enabled!',
			'2FA_disabled_success'				=>	'2FA Disabled!',
			'incorrect_password_err'			=>	'Incorrect password!',
			'update_privacy_success'			=>	'Update privacy successfully!',
			'update_commission_share_success'	=>	'Update commission share successfully!',
			'verification_required_err'			=>	'Please verify your email before withdrawing!',
			'invalid_address_err'				=>	'Please enter the valid withdrawal address!',
			'balance_not_enough_err'			=>	'You have less than %.8f BNB. Wait for minimum amount!', //($minimum_withdrawal / 100000000)
			'withdrawal_amount_too_less_err'	=>	'Minimum withdrawal amount is %.8f BNB!', //($minimum_withdrawal / 100000000)
			'amount_too_much_err'				=>	'The withdrawal amount is greater than your account balance!',
			'withdraw_too_often_err'			=>	'You are trying too often. Please try again later!',
			'withdrawal_being_processed'		=>	'Your withdrawal request is being processed!',
			'withdrawal_confirmation_required'	=>	'Please confirm the withdrawal request by clicking on the link we sent to your email!',
			'transaction_not_exist_err'			=>	'This request does not exist!',
			'transaction_not_exist_err2'		=>	'The request has been canceled or does not exist!',
			'transaction_canceled_success'		=>	'Your request has been canceled!',
			'feature_being_upgrade'				=>	'This feature is being upgraded!',
			'empty_email_err'					=>	'Please enter your email!',
			'invalid_email_err'					=>	'Your email is not a valid email address!',
			'empty_subject_err'					=>	'Please enter the subject!',
			'empty_message_err'					=>	'Please enter the message!',
			'send_message_too_often_err'		=>	'Please send each message after 1 minute!',
			'ticket_closed'						=>	'This ticket is closed!',
			'send_message_success'				=>	'Your message has been successfully sent!',
			'empty_client_seed_err'				=>	'Please enter your client seed!',
			'change_client_seed_success'		=>	'Change client seed successfully!',
			'bet_amount_too_less_err'			=>	'Bet amount must be at least %.8f BNB!', //($MIN_BET_AMOUNT / 100000000)
			'insufficient_balance_err'			=>	'Insufficient balance!',
			'bet_amount_too_much_err'			=>	'Bet amount must be less than or equal to %.8f BNB!', //($MAX_BET_AMOUNT / 100000000)
			'min_payout_err'					=>	'Min payout must be more than or equal to %f!', //$MIN_PAYOUT
			'max_payout_err'					=>	'Max payout must be less than or equal to %f!', //$MAX_PAYOUT
			'select_lower_higher'				=>	'Please select lower or higher!',
			'select_inside_outside'				=>	'Please select inside or outside!',
			'connection_timeout'				=>	'Connection timeout!',
			'create_game_err'					=>	'Can`t create new game!',
			'select_difficulty_err'				=>	'Please select the difficulty!',
			'create_game_success'				=>	'Create new game successfully!',
			'unstarted_game_err'				=>	'Please click start first!',
			'choose_tile_err'					=>	'Please choose the correct tile!',
			'open_a_bomb'						=>	'You opened a bomb!',
			'open_a_gem'						=>	'You opened a gem!',
			'open_all_gems'						=>	'You opened all gems!',
			'no_tiles_selected_err'				=>	'Please select at least one tile!',
			'cashout_success'					=>	'Bet cashed out successfully!',
			'select_num_mines_err'				=>	'Please select the number of mines!',
			'select_num_lines_err'				=>	'Please select number of lines',
			'tile_chosen_err'					=>	'This tile was chosen!',
			'game_created_err'					=>	'You already have an active game. Please finish that one before starting a new game!',
			'tile_limited_err'					=>	'Number of tiles beyond the limit!',
			'unexpected_err'					=>	'Unexpected error!',
			'select_player_banker_err'			=>	'Please select banker, player or tie!',
			'invalid_start_card_err'			=>	'Invalid start card!',
			'you_lose'							=>	'You lose!',
			'open_new_card'						=>	'You open a new card!',
			'can_not_cashout_err'				=>	'You can`t cashout!',
			'invalid_txid_err'					=>	'Please enter valid transaction ID!',
			'invalid_network_err'				=>	'Invalid network!',
			'credited_txid_err'					=>	'The transaction has been already credited!',
			'update_transaction_success'		=>	'Update transaction successfully!',
			'load_data_success'					=>	'Load data successfully!',
			'invalid_game_id_err'				=>	'Game id does not exist!',
			'load_game_seed_failed'				=>	'Can not load game seeds!',
			'deposit_credited_success'			=>	'You have successfully deposited %.8f BNB!', //($total_amount / 100000000)
		);
		
		public function __construct() {}
		
		public function print($key, ...$params) {
			if (isset($this->langs[$key])) {
				if (!empty($params)) {
					return vsprintf($this->langs[$key], $params);
				}
				return $this->langs[$key];
			}
			return '';
		}
	}
?>